<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification_Recipients extends Model 
{

    protected $table = 'notification_recipients';
    public $timestamps = true;
    protected $fillable = array('inquiry_id', 'user_id', 'inquiry_owner', 'notification_frequency_id');
    protected $visible = array('inquiry_id', 'user_id', 'inquiry_owner', 'notification_frequency_id');

    public function user()
    {
        return $this->hasOne('App\Models\User', 'user_id');
    }

    public function inquiry()
    {
        return $this->belongsTo('App\Models\Inquiry', 'inquiry_id');
    }

    public function notification_requency()
    {
        return $this->belongsTo('App\Models\NotificationFrequency', 'notification_frequency_id');
    }

}